/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.toy;

import edu.princeton.swing.PSwingUtilities;
import edu.princeton.toy.TImageManager;
import edu.princeton.toy.lang.TVirtualMachine;
import edu.princeton.toy.lang.TWordBuffer;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TSimStdin2Pane
extends JPanel
implements Scrollable {
    private static final String CLASS_STRING = TSimStdin2Pane.class.toString();
    public static final String RESCALE_COMMAND = CLASS_STRING + "#rescaleCommand";
    public static final String UPDATE_COMMAND = CLASS_STRING + "#updateCommand";
    public static final int MIN_SCALE = 2;
    public static final int MAX_SCALE = TImageManager.MAX_SCALE[1];
    public static final int PREFERRED_SCALE = 7;
    private static final Integer[] INTEGERS = new Integer[MAX_SCALE];
    private static final Font[] FONT_CACHE = new Font[MAX_SCALE];
    private static final int UNSCALED_MINIMUM_PAGE_WIDTH = 38;
    private static final int UNSCALED_PREFERRED_PAGE_WIDTH = 48;
    private static final int UNSCALED_HEIGHT = 84;
    private static final int ROW_COUNT = 40;
    private static final Dimension PREFERRED_SCROLLABLE_VIEWPORT_SIZE = new Dimension(336, 588);
    private static final Color BACKGROUND;
    private static final Color DISABLED_HOLE_COLOR;
    private static final Color DISABLED_HOLE_HIGHLIGHT_COLOR;
    private static final Color DISABLED_HOLE_SHADOW_COLOR;
    private static final Color UNSELECTED_HOLE_COLOR;
    private static final Color UNSELECTED_HOLE_HIGHLIGHT_COLOR;
    private static final Color UNSELECTED_HOLE_SHADOW_COLOR;
    private static final Color SELECTION_BORDER_COLOR;
    private static final Color SELECTED_HOLE_COLOR;
    private static final Color SELECTED_HOLE_HIGHLIGHT_COLOR;
    private static final Color SELECTED_HOLE_SHADOW_COLOR;
    private static final Color SELECTED_TEXT_COLOR;
    private static final Border PLACEHOLDER_BORDER;
    private int cardCount;
    private int unscaledWidth;
    private int scale;
    private int offsetX;
    private int offsetY;
    private JLabel selectedTextRenderer;
    private Image disabledCardImage;
    private Image unselectedCardImage;
    private Image selectedCardImage;
    private Runner runner;
    private boolean showPlaceholders;
    private JLabel placeholderLabel;
    private int newScale;
    private int selectedIndex;
    private int dragOffset;
    TWordBuffer consumedStdin;
    TWordBuffer oldConsumedStdin;
    TWordBuffer unconsumedStdin;
    TWordBuffer oldUnconsumedStdin;
    private Listener listener;
    private TVirtualMachine virtualMachine;

    public TSimStdin2Pane(TVirtualMachine virtualMachine) {
        this.setForeground(Color.black);
        if (virtualMachine == null) {
            throw new NullPointerException();
        }
        this.virtualMachine = virtualMachine;
        this.consumedStdin = new TWordBuffer();
        this.oldConsumedStdin = new TWordBuffer();
        this.unconsumedStdin = new TWordBuffer();
        this.oldUnconsumedStdin = new TWordBuffer();
        this.runner = new Runner();
        this.listener = new Listener();
        virtualMachine.addChangeListener(this.listener);
        this.selectedTextRenderer = new JLabel("", 2);
        this.selectedTextRenderer.setOpaque(false);
        this.selectedTextRenderer.setVerticalTextPosition(0);
        this.selectedTextRenderer.setForeground(SELECTED_TEXT_COLOR);
        this.placeholderLabel = new JLabel("Visual X-TOY is curently resizing the graphics needed for sim mode...", 0);
        this.placeholderLabel.setOpaque(false);
        this.placeholderLabel.setVerticalTextPosition(0);
        this.selectedIndex = -1;
        this.scale = -1;
        this.doCommand(RESCALE_COMMAND, INTEGERS[TImageManager.ORIGINAL_IMAGE_SCALES[1]]);
        this.setMinimumSize(new Dimension(2, 168));
        this.enableEvents(65585L);
    }

    public void setVirtualMachine(TVirtualMachine virtualMachine) {
        if (virtualMachine == null) {
            throw new NullPointerException();
        }
        if (this.virtualMachine == virtualMachine) {
            return;
        }
        this.virtualMachine.removeChangeListener(this.listener);
        virtualMachine.addChangeListener(this.listener);
        this.virtualMachine = virtualMachine;
        this.doCommand(UPDATE_COMMAND, Boolean.FALSE);
    }

    public TVirtualMachine getVirtualMachine() {
        return this.virtualMachine;
    }

    public synchronized boolean doCommand(String command, Object extraInfo) {
        if (command == RESCALE_COMMAND) {
            int scale = (Integer)extraInfo;
            if (scale < 2 || scale > MAX_SCALE) {
                throw new IllegalArgumentException();
            }
            if (scale == this.scale) {
                this.repaint();
                return false;
            }
            Dimension preferredSize = this.getPreferredSize();
            preferredSize.width = 2 * this.offsetX + this.unscaledWidth * scale;
            this.setPreferredSize(preferredSize);
            this.scale = scale;
            if (FONT_CACHE[scale] == null) {
                TSimStdin2Pane.FONT_CACHE[scale] = new Font("Monospaced", 1, (int)(1.8 * (double)scale));
            }
            this.selectedTextRenderer.setFont(FONT_CACHE[scale]);
            this.selectedTextRenderer.setBounds(0, 0, 11 * scale, 2 * scale);
            this.disabledCardImage = TImageManager.getImage((byte)1, scale, (short)0);
            this.unselectedCardImage = TImageManager.getImage((byte)1, scale, (short)1);
            this.selectedCardImage = TImageManager.getImage((byte)1, scale, (short)2);
            this.revalidate();
            this.repaint();
            return true;
        }
        if (command == UPDATE_COMMAND) {
            boolean consumedStdinUnchanged;
            TWordBuffer tempBuffer = this.oldConsumedStdin;
            this.oldConsumedStdin = this.consumedStdin;
            this.consumedStdin = tempBuffer;
            tempBuffer = this.oldUnconsumedStdin;
            this.oldUnconsumedStdin = this.unconsumedStdin;
            this.unconsumedStdin = tempBuffer;
            this.virtualMachine.getConsumedStdin(this.consumedStdin);
            this.virtualMachine.getUnconsumedStdin(this.unconsumedStdin);
            int cardCount = (this.unconsumedStdin.getSize() + this.consumedStdin.getSize()) / 40 + 1;
            if (this.cardCount != cardCount) {
                this.cardCount = cardCount;
                this.unscaledWidth = cardCount * 48 - 10;
                Dimension preferredSize = this.getPreferredSize();
                preferredSize.width = 2 * this.offsetX + this.unscaledWidth * this.scale;
                this.setPreferredSize(preferredSize);
                this.revalidate();
            }
            if (!(consumedStdinUnchanged = this.consumedStdin.equals(this.oldConsumedStdin)) || !this.unconsumedStdin.equals(this.oldUnconsumedStdin)) {
                if (extraInfo != null && ((Boolean)extraInfo).booleanValue()) {
                    this.scrollToFrontier(!consumedStdinUnchanged || this.unconsumedStdin.getSize() <= this.oldUnconsumedStdin.getSize());
                } else {
                    this.repaint();
                }
            }
            return true;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void paintComponent(Graphics g) {
        Rectangle clip = g.getClipBounds();
        int scale = this.scale;
        g.setColor(BACKGROUND);
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
        int offsetX = this.offsetX;
        int offsetY = this.offsetY;
        int cardStart = Math.max(0, (clip.x - offsetX) / scale / 48);
        int cardEnd = Math.min(this.cardCount - 1, (clip.x + clip.width - offsetX) / scale / 48);
        if (this.showPlaceholders) {
            scale = this.newScale;
            this.placeholderLabel.setBounds(0, 0, 48 * scale, this.getHeight());
            for (int cardCtr = cardStart; cardCtr <= cardEnd; ++cardCtr) {
                int cardX = offsetX + cardCtr * 48 * scale;
                int cardY = offsetY;
                PLACEHOLDER_BORDER.paintBorder(this, g, cardX, cardY, 38 * scale, 84 * scale);
                g.translate(cardX - 5 * scale, 0);
                this.placeholderLabel.paint(g);
                g.translate(-(cardX - 5 * scale), 0);
            }
            return;
        }
        int holeWidth = 2 * scale;
        int holeHeight = (scale + 1) / 2;
        TWordBuffer consumedStdin = this.consumedStdin;
        TWordBuffer unconsumedStdin = this.unconsumedStdin;
        int consumedStdinSize = consumedStdin.getSize();
        int stdinSize = consumedStdinSize + unconsumedStdin.getSize();
        int selectedIndex = this.selectedIndex;
        if (selectedIndex == -1) {
            selectedIndex = consumedStdinSize;
        }
        Image disabledCardImage = this.disabledCardImage;
        Image unselectedCardImage = this.unselectedCardImage;
        Image selectedCardImage = this.selectedCardImage;
        for (int cardCtr = cardStart; cardCtr <= cardEnd; ++cardCtr) {
            int cardX = offsetX + cardCtr * 48 * scale;
            int cardY = offsetY;
            g.drawImage(unselectedCardImage, cardX, cardY, null);
            if (cardCtr * 40 < consumedStdinSize) {
                int disabledEndRow = Math.min(40, consumedStdinSize - cardCtr * 40);
                int disabledEndY = disabledEndRow == 40 ? 84 * scale : (9 + 8 * disabledEndRow) * scale / 4;
                g.drawImage(disabledCardImage, cardX, cardY, cardX + 38 * scale, cardY + disabledEndY, 0, 0, 38 * scale, disabledEndY, null);
            }
            if ((cardCtr + 1) * 40 > stdinSize + 1) {
                int disabledStartRow = Math.max(0, stdinSize + 1 - cardCtr * 40);
                int disabledStartY = disabledStartRow == 0 ? 0 : (9 + 8 * disabledStartRow) * scale / 4;
                g.drawImage(disabledCardImage, cardX, cardY + disabledStartY, cardX + 38 * scale, cardY + 84 * scale, 0, disabledStartY, 38 * scale, 84 * scale, null);
            }
            if (selectedIndex >= 0 && selectedIndex / 40 == cardCtr) {
                int selectionRow = selectedIndex % 40;
                int selectionY = (9 + 8 * selectionRow) * scale / 4;
                g.drawImage(selectedCardImage, cardX, cardY + selectionY, cardX + 38 * scale, cardY + selectionY + 2 * scale, 0, selectionY, 38 * scale, selectionY + 2 * scale, null);
                g.setColor(SELECTION_BORDER_COLOR);
                g.drawLine(cardX, cardY + selectionY, cardX + 38 * scale - 1, cardY + selectionY);
                g.drawLine(cardX + 38 * scale - 1, cardY + selectionY, cardX + 38 * scale - 1, cardY + selectionY + 2 * scale - 1);
                g.drawLine(cardX, cardY + selectionY + 2 * scale - 1, cardX + 38 * scale - 1, cardY + selectionY + 2 * scale - 1);
                g.drawLine(cardX, cardY + selectionY, cardX, cardY + selectionY + 2 * scale - 1);
                g.translate(cardX + 27 * scale, cardY + selectionY);
                if (selectedIndex < consumedStdinSize) {
                    this.selectedTextRenderer.setText(consumedStdin.getWord(selectedIndex).toHexString(false));
                } else if (selectedIndex < stdinSize) {
                    this.selectedTextRenderer.setText(unconsumedStdin.getWord(selectedIndex - consumedStdinSize).toHexString(false));
                } else {
                    this.selectedTextRenderer.setText("(Prompt)");
                }
                this.selectedTextRenderer.paint(g);
                g.translate(-(cardX + 27 * scale), -(cardY + selectionY));
            }
            for (int rowCtr = 0; rowCtr < 40; ++rowCtr) {
                Color holeShadowColor;
                Color holeHighlightColor;
                Color holeColor;
                short value;
                int index = cardCtr * 40 + rowCtr;
                if (index >= stdinSize || (value = index < consumedStdinSize ? consumedStdin.getWord(index).getValue() : unconsumedStdin.getWord(index - consumedStdinSize).getValue()) == 0) continue;
                if (index == selectedIndex) {
                    holeColor = SELECTED_HOLE_COLOR;
                    holeHighlightColor = SELECTED_HOLE_HIGHLIGHT_COLOR;
                    holeShadowColor = SELECTED_HOLE_SHADOW_COLOR;
                } else if (index < consumedStdinSize) {
                    holeColor = DISABLED_HOLE_COLOR;
                    holeHighlightColor = DISABLED_HOLE_HIGHLIGHT_COLOR;
                    holeShadowColor = DISABLED_HOLE_SHADOW_COLOR;
                } else {
                    holeColor = UNSELECTED_HOLE_COLOR;
                    holeHighlightColor = UNSELECTED_HOLE_HIGHLIGHT_COLOR;
                    holeShadowColor = UNSELECTED_HOLE_SHADOW_COLOR;
                }
                int holeY0 = cardY + (5 + 4 * rowCtr) * scale / 2;
                int holeY1 = cardY + (5 + 4 * rowCtr + 2) * scale / 2;
                for (int ctr = 0; ctr < 8; ++ctr) {
                    int holeX = cardX + (5 + 6 * ctr) * scale / 2;
                    if ((value >> 15 - ctr & 1) != 0) {
                        g.setColor(holeColor);
                        g.fillRect(holeX, holeY0, holeWidth, holeHeight);
                        g.setColor(holeHighlightColor);
                        g.drawLine(holeX, holeY0 + holeHeight - 1, holeX + holeWidth - 1, holeY0 + holeHeight - 1);
                        g.drawLine(holeX, holeY0, holeX, holeY0 + holeHeight - 1);
                        g.setColor(holeShadowColor);
                        g.drawLine(holeX, holeY0, holeX + holeWidth - 1, holeY0);
                        g.drawLine(holeX + holeWidth - 1, holeY0, holeX + holeWidth - 1, holeY0 + holeHeight - 1);
                    }
                    if ((value >> 7 - ctr & 1) == 0) continue;
                    g.setColor(holeColor);
                    g.fillRect(holeX, holeY1, holeWidth, holeHeight);
                    g.setColor(holeHighlightColor);
                    g.drawLine(holeX, holeY1 + holeHeight - 1, holeX + holeWidth - 1, holeY1 + holeHeight - 1);
                    g.drawLine(holeX, holeY1, holeX, holeY1 + holeHeight - 1);
                    g.setColor(holeShadowColor);
                    g.drawLine(holeX, holeY1, holeX + holeWidth - 1, holeY1);
                    g.drawLine(holeX + holeWidth - 1, holeY1, holeX + holeWidth - 1, holeY1 + holeHeight - 1);
                }
            }
        }
    }

    @Override
    protected void processHierarchyBoundsEvent(HierarchyEvent e) {
        if (e.getID() == 1402 && e.getChanged() == this.getParent() && e.getChanged() instanceof JViewport) {
            this.deriveScale();
        }
    }

    @Override
    protected void processComponentEvent(ComponentEvent e) {
        if (e.getID() == 101) {
            this.deriveScale();
        }
        super.processComponentEvent(e);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        switch (e.getID()) {
            case 501: {
                Container parent;
                if ((e.getModifiers() & 0x10) == 0 || !((parent = this.getParent()) instanceof JViewport)) break;
                this.dragOffset = e.getX() + this.getX() + ((JViewport)parent).getViewPosition().x;
                break;
            }
            case 505: {
                if (this.selectedIndex == -1 || (e.getModifiers() & 0x10) != 0) break;
                this.selectedIndex = -1;
                this.repaint();
            }
        }
        super.processMouseEvent(e);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        switch (e.getID()) {
            case 506: {
                int paneWidth;
                Container parent;
                if ((e.getModifiers() & 0x10) == 0 || !((parent = this.getParent()) instanceof JViewport)) break;
                JViewport viewport = (JViewport)parent;
                Rectangle rectangle = viewport.getViewRect();
                int newPosition = this.dragOffset - (e.getX() + this.getX());
                if (newPosition + rectangle.width > (paneWidth = this.getPreferredSize().width)) {
                    newPosition = paneWidth - rectangle.width;
                }
                if (newPosition < 0) {
                    newPosition = 0;
                }
                viewport.setViewPosition(new Point(newPosition, rectangle.y));
                break;
            }
            case 503: {
                int tempInt = (e.getX() - this.offsetX) / this.scale;
                int selectedIndex = -1;
                if (tempInt >= 0 && tempInt % 48 < 38) {
                    int card = tempInt / 48;
                    int row = ((e.getY() - this.offsetY) * 4 / this.scale - 9) / 8;
                    if (row >= 0 && row < 40 && (selectedIndex = card * 40 + row) > this.consumedStdin.getSize() + this.unconsumedStdin.getSize()) {
                        selectedIndex = -1;
                    }
                }
                if (selectedIndex == this.selectedIndex) break;
                this.selectedIndex = selectedIndex;
                this.repaint();
            }
        }
        super.processMouseEvent(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deriveScale() {
        int height = this.getHeight();
        int scale = height / 84;
        if (this.getParent() instanceof JViewport) {
            int width = ((JViewport)this.getParent()).getWidth();
            scale = Math.min(scale, width / 38);
        }
        if (scale < 2) {
            scale = 2;
        }
        if (scale > MAX_SCALE) {
            scale = MAX_SCALE;
        }
        this.offsetX = 5 * scale;
        this.offsetY = height / 2 - 84 * scale / 2;
        TSimStdin2Pane tSimStdin2Pane = this;
        synchronized (tSimStdin2Pane) {
            this.newScale = scale;
            if (!this.runner.isRunning) {
                if (!TImageManager.isPrepared((byte)1, scale)) {
                    this.showPlaceholders = true;
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    Dimension preferredSize = this.getPreferredSize();
                    preferredSize.width = 2 * this.offsetX + this.unscaledWidth * scale;
                    this.setPreferredSize(preferredSize);
                    PSwingUtilities.revalidateImmediately(this);
                    PSwingUtilities.paintWindowImmediately(this);
                    this.runner.start();
                } else {
                    this.doCommand(RESCALE_COMMAND, INTEGERS[scale]);
                }
            } else {
                Dimension preferredSize = this.getPreferredSize();
                preferredSize.width = 2 * this.offsetX + this.unscaledWidth * scale;
                this.setPreferredSize(preferredSize);
                PSwingUtilities.revalidateImmediately(this);
                PSwingUtilities.paintWindowImmediately(this);
            }
        }
    }

    public void scrollToFrontier(boolean consumedFrontier) {
        int selectedCard = consumedFrontier ? this.consumedStdin.getSize() / 40 : (this.consumedStdin.getSize() + this.unconsumedStdin.getSize()) / 40;
        this.scrollRectToVisible(new Rectangle(selectedCard * 48 * this.scale + this.offsetX, 0, 38 * this.scale, this.getHeight()));
        this.repaint();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return PREFERRED_SCROLLABLE_VIEWPORT_SIZE;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        switch (orientation) {
            case 1: {
                return visibleRect.height / 10;
            }
            case 0: {
                return visibleRect.width / 10;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + orientation);
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        switch (orientation) {
            case 1: {
                return visibleRect.height;
            }
            case 0: {
                return visibleRect.width;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + orientation);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return true;
    }

    static {
        DISABLED_HOLE_COLOR = BACKGROUND = new Color(204, 204, 204);
        DISABLED_HOLE_HIGHLIGHT_COLOR = new Color(126, 126, 126);
        DISABLED_HOLE_SHADOW_COLOR = new Color(92, 92, 92);
        UNSELECTED_HOLE_COLOR = BACKGROUND;
        UNSELECTED_HOLE_HIGHLIGHT_COLOR = new Color(177, 137, 75);
        UNSELECTED_HOLE_SHADOW_COLOR = new Color(129, 100, 55);
        SELECTION_BORDER_COLOR = new Color(102, 102, 154);
        SELECTED_HOLE_COLOR = Color.white;
        SELECTED_HOLE_HIGHLIGHT_COLOR = new Color(145, 146, 183);
        SELECTED_HOLE_SHADOW_COLOR = new Color(102, 102, 154);
        SELECTED_TEXT_COLOR = Color.black;
        PLACEHOLDER_BORDER = new EtchedBorder(1);
        for (int ctr = 0; ctr < MAX_SCALE; ++ctr) {
            TSimStdin2Pane.INTEGERS[ctr] = new Integer(ctr);
        }
    }

    protected class Runner
    implements Runnable {
        protected boolean isRunning = false;
        private Thread thread;

        protected Runner() {
        }

        public void start() {
            this.isRunning = true;
            this.thread = new Thread(this);
            this.thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                int scale;
                TSimStdin2Pane tSimStdin2Pane = TSimStdin2Pane.this;
                synchronized (tSimStdin2Pane) {
                    scale = TSimStdin2Pane.this.newScale;
                    if (TImageManager.isPrepared((byte)1, scale)) {
                        TSimStdin2Pane.this.doCommand(RESCALE_COMMAND, INTEGERS[scale]);
                        TSimStdin2Pane.this.showPlaceholders = false;
                        TSimStdin2Pane.this.setCursor(Cursor.getPredefinedCursor(0));
                        TSimStdin2Pane.this.repaint();
                        this.isRunning = false;
                        this.thread = null;
                        return;
                    }
                }
                TImageManager.prepare((byte)1, scale);
            }
        }
    }

    protected class Listener
    implements ChangeListener {
        protected Listener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            TSimStdin2Pane.this.doCommand(UPDATE_COMMAND, Boolean.TRUE);
        }
    }
}

